<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FinancialPeriod extends Model 
{

    protected $table = 'financial_periods';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function invoices()
    {
        return $this->hasMany('App\Models\Finance\Invoice', 'financial_period_id');
    }

    public function gross_pay()
    {
        return $this->hasMany('App\Models\HR\AppointmentGrossPay', 'financial_period_id');
    }

}